#include "CSettingsDialog.h"

#include <QMessageBox>
#include <QTimer>
#include <QrfeTrace>

#include "../../Settings.h"
#include "../../sound/SoundManager.h"
#include "../../permission/Permissions.h"

#include <QrfeReaderInterface>

CSettingsDialog::CSettingsDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);

	ui.traceGroupBox->setVisible(false);
	ui.readerGroupBox->setVisible(false);

	connect(ui.refreshRateHorizontalSlider, SIGNAL(valueChanged(int)), 	this, SLOT(refreshRateSliderChanged(int)));

	connect(ui.okButton, 			SIGNAL(clicked()), 					this, SLOT(tryAccept()));

	QTimer::singleShot(0, this, SLOT(shrink()));
}

CSettingsDialog::~CSettingsDialog()
{

}

int CSettingsDialog::exec()
{
	ui.refreshRateHorizontalSlider->setValue(Settings::d->refreshRate());
	refreshRateSliderChanged(Settings::d->refreshRate());

	ui.attachReaderAutomaticallyCheckBox->setChecked(Settings::d->attachReaderAutomatically());

    ui.tryParseTagIdsCheckBox->setChecked(Settings::d->parseTagIds());
    ui.showTagIdAsciiCheckBox->setChecked(Settings::d->showTagIdAscii());

	ui.useTtlCheckBox->setChecked(Settings::d->ttlOn());
	ui.inactiveSpinBox->setValue(Settings::d->ttlInactive());
	ui.outOfRangeSpinBox->setValue(Settings::d->ttlOutOfRange());
	ui.deleteSpinBox->setValue(Settings::d->ttlDelete());

	ui.useMultiplexBox->setChecked(Settings::d->multiplexOn());
	ui.multiplexReadTimeBox->setValue(Settings::d->multiplexTime());

	ui.tagReadBeepBox->setChecked(Settings::d->readBeepOn());

	ui.tagReadBeepTypeComboBox->clear();
	ui.tagReadBeepTypeComboBox->addItems(SoundManager::d->playlist());
	ui.tagReadBeepTypeComboBox->setCurrentIndex
		(
			(Settings::d->readBeepType() > (uint)(ui.tagReadBeepTypeComboBox->count() - 1) ) ?
					(ui.tagReadBeepTypeComboBox->count() - 1) :
					Settings::d->readBeepType()
		);
	ui.tagReadBeepParallelBox->setValue(Settings::d->readBeepParallel());

	if(Permissions::d->traceEnabled())
	{
		ui.traceGroupBox->setVisible(true);
		ui.traceBox->setChecked(Settings::d->traceOn());
		ui.traceLevelBox->setValue(Settings::d->traceLevel());
	}

	if(Permissions::d->readerEngineering())
	{
		ui.readerGroupBox->setVisible(true);
		ui.heartbeatMultiplierBox->setValue(QrfeReaderInterface::_heartBeatMultiplier);
	}

	return QDialog::exec();
}

void CSettingsDialog::tryAccept()
{
	if(ui.inactiveSpinBox->value() > ui.outOfRangeSpinBox->value() || ui.outOfRangeSpinBox->value() > ui.deleteSpinBox->value())
	{
		QMessageBox::critical(this, "Error", "The time settings must be in order.");
		return;
	}

	Settings::d->setRefreshRate(ui.refreshRateHorizontalSlider->value());

	Settings::d->setAttachReaderAutomatically(ui.attachReaderAutomaticallyCheckBox->isChecked());

    Settings::d->setParseTagIds(ui.tryParseTagIdsCheckBox->isChecked());
    Settings::d->setShowTagIdAscii(ui.showTagIdAsciiCheckBox->isChecked());

	Settings::d->setTtlOn( ui.useTtlCheckBox->isChecked() );
	Settings::d->setTtlInactive( ui.inactiveSpinBox->value() );
	Settings::d->setTtlOutOfRange( ui.outOfRangeSpinBox->value() );
	Settings::d->setTtlDelete( ui.deleteSpinBox->value() );

	Settings::d->setMultiplexOn( ui.useMultiplexBox->isChecked() );
	Settings::d->setMultiplexTime( ui.multiplexReadTimeBox->value() );

	Settings::d->setReadBeep( ui.tagReadBeepBox->isChecked() );
	Settings::d->setReadBeepType( ui.tagReadBeepTypeComboBox->currentIndex() );
	Settings::d->setReadBeepParallel( ui.tagReadBeepParallelBox->value() );

	Settings::d->storeSettings();

	if(Permissions::d->traceEnabled())
	{
		emit appendGlobalJob(JOB_ShowHideTraceWindow, QList<QVariant>() << ui.traceBox->isChecked() << (int)ui.traceLevelBox->value());
		Settings::d->setTraceOn(ui.traceBox->isChecked());
		Settings::d->setTraceLevel((int)ui.traceLevelBox->value());
	}

	if(Permissions::d->readerEngineering())
	{
		QrfeReaderInterface::_heartBeatMultiplier = ui.heartbeatMultiplierBox->value();
	}

	accept();
}

void CSettingsDialog::shrink()
{
	this->resize(0,0);
}

void CSettingsDialog::refreshRateSliderChanged(int val)
{
	ui.refreshRateLabel->setText(QString::number(val) + " msecs");
}
